% function SysInit(noOfBytes)
% Desciption: System initialization
% Input buffer: 12500 bytes
% Interrupt generated when terminator received, call function ReceiveData
if exist('s','var')
fclose(s);
delete(s);
end
clc
global s;
global noOfBytes;
global upperLimit;
global lowerLimit;
global range;
global DACPrecision;
global ADCPrecision;
global recordNoOfPoints;
global recordStartVoltage;
global recordEndVoltage;
global comName;
errorHappen = 0;
lowerLimit = -11.34;
upperLimit = 11.34;
range = upperLimit - lowerLimit;
DACPrecision = range / 65536;
ADCPrecision = 3.814697e-5;
noOfBytes = 9;

s = serial(comName);
set(s,'BaudRate', 57600, 'DataBits', 8, 'Parity', 'none','StopBits', 1, 'FlowControl', 'none'); 
%set(s,'Timeout',600);
s.Timeout = 10;
s.InputBufferSize = 100000;
try
fopen(s);
catch err
    errorHappen = 1;
end
if(errorHappen == 1)
fprintf('%s open failed.\n', comName);
else
fprintf('%s open succeed.\n', comName);
end